% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_level_disprop_analysis.R
\name{ci_for_prr}
\alias{ci_for_prr}
\title{Confidence intervals for Proportional Reporting Rate}
\usage{
ci_for_prr(
  obs = NULL,
  n_drug = NULL,
  n_event_prr = NULL,
  n_tot_prr = NULL,
  conf_lvl_probs = 0.95
)
}
\arguments{
\item{obs}{Number of reports for the specific drug and event (i.e. the
observed count).}

\item{n_drug}{Number of reports with the drug of interest.}

\item{n_event_prr}{Number of reports with the event in the background.}

\item{n_tot_prr}{Number of reports in the background.}

\item{conf_lvl_probs}{The probabilities of the normal distribution, based on
a passed confidence level (\code{conf_lvl}) in \code{\link{prr}}. If
\code{sgn_lvl = .95} in \code{prr}, quantiles of the normal distribution will
be extracted at \code{sgn_lvl_probs} of 0.025 and 0.975.}
}
\value{
The confidence interval specified by input parameters.
}
\description{
Mainly for use in \code{\link{prr}}. Produces (symmetric,
normality based) confidence bounds for the PRR, for a passed probability.
Called twice in \code{prr} to create confidence intervals.
}
\seealso{
\code{\link{prr}}
}
