% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_predict_topologies_from_sequences.R
\name{mock_predict_topologies_from_sequences}
\alias{mock_predict_topologies_from_sequences}
\title{Do a mock prediction directy on a protein sequence,
as can be useful in testing
Use \link{predict_topologies_from_sequences} for doing a real prediction.}
\usage{
mock_predict_topologies_from_sequences(protein_sequences)
}
\arguments{
\item{protein_sequences}{one ore more protein sequence,
each sequence with the amino acids as capitals, for
example \code{MEILCEDNTSLSSIPNSL}}
}
\value{
a topology as a string of zeroes and ones, where a one denotes
that the corresponding amino acid is located within the membrane.
}
\description{
Do a mock prediction directy on a protein sequence,
as can be useful in testing
Use \link{predict_topologies_from_sequences} for doing a real prediction.
}
\examples{
protein_sequence <- paste0(
  "QEKNWSALLTAVVIILTIAGNILVIMAVSLEKKLQNATNYFLM",
  "SLAIADMLLGFLVMPVSMLTILYGYRWP"
)
mock_predict_topologies_from_sequences(protein_sequence)
}
\author{
Richèl J.C. Bilderbeek
}
