% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{loo,mafit-method}
\alias{loo,mafit-method}
\title{Calculate the \code{loo} for an \code{ma} object.}
\usage{
\S4method{loo}{mafit}(x, ...)
}
\arguments{
\item{x}{an object of class \code{mafit}.}

\item{...}{passed to \code{\link[loo:loo]{loo}}. Only}
}
\value{
A \code{\link[loo:loo]{loo}} object.
}
\description{
Computes PSIS-LOO CV, approximate leave-one-out cross-validation
using Pareto smoothed importance sampling, see \code{\link[loo:loo]{loo}}.
}
\details{
\code{...} affect the function through two parameters, \code{marginal} and
\code{lower_bound}. When \code{marginal}is \code{TRUE}, the PSIS-LOO CV is based on the
marginal likelihood, i.e. with the dependence on \code{theta} integrated out.
\code{marginal} defaults to \code{TRUE}. \code{lower_bound} species the lower bound where
log-likelihoods are dropped; this is only used in the \emph{p}-hacking model
and defaults to -6.
}
\examples{
\donttest{
phma_model <- phma(yi, vi, data = metadat::dat.begg1989)
psma_model <- psma(yi, vi, data = metadat::dat.begg1989)
loo(phma_model)
loo(psma_model)
}
}
