% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex.R
\name{hex_wd}
\alias{hex_wd}
\title{Get width of hexagon given height}
\usage{
hex_wd(height)
}
\arguments{
\item{height}{scaler}
}
\value{
A scaler for the width
}
\description{
Get width of hexagon given height
}
\details{
For use with ggplot and \code{geom_hex} binwidth arguments, which expects arguments in width/height. I want hexagons in maps to be a specific area. See \href{https://andrewpwheeler.com/2019/08/07/making-a-hexbin-map-in-ggplot/}{this blog post} for a specific use case with ggplot.
}
\examples{
area_check <- 1000
wh <- hex_dim(area_check^2)   #e.g. a square kilometer if spatial units are in meters
area <- hex_area(wh[1]/2)       #inverse operation
all.equal(area_check,sqrt(area))
wi <- hex_wd(wh[1])
all.equal(wh[2],wi)

}
\seealso{
\code{\link[=hex_area]{hex_area()}} for estimating the area given side length
\code{\link[=hex_dim]{hex_dim()}} for estimating width/height given area
}
