% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_spectral_density.R
\name{PSDIdentifyDominantFrequency}
\alias{PSDIdentifyDominantFrequency}
\title{Given a time series vector, create a PSD and find the dominant frequency}
\usage{
PSDIdentifyDominantFrequency(
  sampling_frequency,
  data_vector,
  x_start = 0,
  x_end,
  x_increment
)
}
\arguments{
\item{sampling_frequency}{Numeric value specifying sampling frequency in hertz. If data is sampled once every second, then sampling frequency is 1 Hz. If data is sampled once every 2 seconds, then sampling frequency is 0.5 Hz.}

\item{data_vector}{Vector of numeric values. Timeseries vector of data.}

\item{x_start}{Numeric value specifying start of x value to look at.}

\item{x_end}{Numeric value specifying end of x value to look at.}

\item{x_increment}{Numeric value specifying the increment of the x-values to use.}
}
\value{
A vector with two elements, The first element is the x value (frequency)
where the max y value (PSD value) is found. The second element is the max y value.
}
\description{
The range to look for a dominant frequency (frequency corresponding to max
PSD value) should be specified for this function. This function uses the
MakePowerSpectralDensity() function and the IdentifyMaxOnXY() function
together. If multiple equal maxima are found, then IdentifyMaxOnXY()
will display a message.
}
\examples{

#Create a vector of time that represent times where data are sampled.
Fs = 100; #sampling frequency in Hz
T = 1/Fs; #sampling period
L = 1000; #length of time vector
t = (0:(L-1))*T; #time vector

#First signal
#1. 1 Hz with amplitude of 2
S1 <- 2*sin(2*pi*1*t)
level1.vals <- rep("a", length(S1))
level2.vals <- rep("1", length(S1))
S1.data.frame <- as.data.frame(cbind(t, S1, level1.vals, level2.vals))
colnames(S1.data.frame) <- c("Time", "Signal", "level1.ID", "level2.ID")
S1.data.frame[,"Signal"] <- as.numeric(S1.data.frame[,"Signal"])


results <- PSDIdentifyDominantFrequency(Fs, S1.data.frame[,"Signal"], 0, 10, 0.01)

}
