% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{plotwithtext}
\alias{plotwithtext}
\title{Plot Dendrogram with Interior Node Text Added}
\usage{
plotwithtext(
  hc,
  imerge = -seq(n),
  text = as.character(1:n),
  bgcol = "white",
  font = 1,
  col = 1,
  cex = 1,
  ...
)
}
\arguments{
\item{hc}{an object of class \code{hclust}}

\item{imerge}{a vector of the nodes where text is desired.
Interior nodes are numbered from 1 (lowest merge) to n - 1 (highest merge,
i.e. the root) and leaf-nodes are negative.  Example:
\code{seq(1, n - 1)} means every interior node is labeled with text. 
Default: \code{-seq(n)}, meaning all leaf labels and no interior-node labels 
are shown.}

\item{text}{a character vector of length matching `imerge`.  The element
`text[i]` will label node `imerge[i]`.}

\item{bgcol}{background color for labels}

\item{col, font}{color and font of labels}

\item{cex}{size of label}

\item{...}{additional arguments to be passed to \code{plot.hclust}, such as
\code{hang}}
}
\description{
Makes a plot of the dendrogram (using \code{plot.hclust}) and adds interior
node text.
}
\details{
This function lets one put text on a dendrogram.  The argument
\code{imerge} controls which interior nodes and leaves are labeled with text.
}
\examples{

# generate some data:
set.seed(1)
n <- 100
p <- 2
x <- matrix(rnorm(n * p), n, p)
rownames(x) <- paste("A", 1:n, sep="")
d <- dist(x)

# perform minimax linkage clustering:
hc <- protoclust(d)

# cut the tree to yield a 10-cluster clustering:
k <- 10 # number of clusters
cut <- protocut(hc, k=k)
h <- hc$height[n - k]

# plot dendrogram (and show cut):
protoclust:::plotwithtext(hc, imerge=cut$imerge, text=paste("Cluster", 1:k))
abline(h=h, lty=2)

# negative values of imerge specify which leaves to label
protoclust:::plotwithtext(hc, imerge=c(-1, cut$imerge), text=c("1", paste("Cluster", 1:k)))
}
\references{
Bien, J., and Tibshirani, R. (2011), "Hierarchical Clustering
with Prototypes via Minimax Linkage," \emph{The Journal of the American 
Statistical Association}, 106(495), 1075-1084.
}
\author{
Jacob Bien and Rob Tibshirani
}
\keyword{cluster}
