% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FP_HMM.R
\name{fp_hmm}
\alias{fp_hmm}
\title{fp_hmm}
\usage{
fp_hmm(hmm)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}
}
\value{
A vector of length 20.

A vector of length 400.
}
\description{
This feature consists of two vectors, \eqn{d, s}. Vector \eqn{d} corresponds to the sums across the sequence
for each of the 20 amino acid columns. Vector \eqn{s} corresponds to a flattened matrix \eqn{S[i, j] = \sum_{k = 1}^{L}
H[k, j] \times \delta[k, i]} in which \eqn{\delta[k, i] = 1} when \eqn{A_i = H[k, j]}. \eqn{A} refers to a list of
all possible amino acids, \eqn{i, j} span from \eqn{1:20}.
}
\examples{
h<- fp_hmm(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Zahiri, J., Yaghoubi, O., Mohammad-Noori, M., Ebrahimpour, R., & Masoudi-Nejad, A. (2013).
PPIevo: Protein–protein interaction prediction from PSSM based evolutionary information.
Genomics, 102(4), 237–242.
}
