% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-projects_author.R
\docType{class}
\name{projects_author}
\alias{projects_author}
\alias{projects_author-class}
\alias{match.projects_author}
\alias{match,projects_author,ANY-method}
\alias{match,ANY,projects_author-method}
\alias{match,projects_author,projects_author-method}
\alias{\%in\%.projects_author}
\alias{\%in\%,projects_author-method}
\title{\code{projects_author} vector}
\usage{
projects_author(x = character())

match.projects_author(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{projects_author,ANY}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{ANY,projects_author}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{projects_author,projects_author}(x, table, nomatch = NA_integer_, incomparables = NULL)

`\%in\%.projects_author`(x, table)

\S4method{\%in\%}{projects_author}(x, table)
}
\arguments{
\item{x}{For \code{projects_author()}, an integer or character vector. For

  For \code{\link{match}()} and \code{\link{\%in\%}}, an integer, a character
  string, or a \code{projects_author} object. See \code{\link{match}()} and
  \strong{Equality and value matching methods} below.}

\item{table}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()}  and
\strong{Equality and value matching methods} below.}

\item{nomatch}{See \code{\link{match}()}.}

\item{incomparables}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()}.}
}
\description{
Objects of this class contain both the \code{id} and the \code{last_name} of
an author so that the package and the user, respectively, can easily identify
the author.
}
\details{
Essentially, this is a character string of the form:

\code{id: last_name}

\code{projects_author()} coerces an integer or character vector to a
\code{projects_author} object, validating each element against the existing
\code{\link{authors}()} table.
}
\section{Numeric coercion methods}{
 \code{\link{as.integer}()},
  \code{\link{as.double}()}, and \code{\link{as.numeric}()} return the
  \code{id} portion of the \code{projects_author} object as an
  integer/double. The methods for the equality and value matching functions
  described below make use of these numeric coercion methods. Users desiring
  to apply value matching functions other than the ones described below may
  similarly take advantage of these.
}

\section{Equality and value matching methods}{
 Methods for \code{\link{==}},
  \code{\link{!=}}, \code{\link{match}()}, and \code{\link{\%in\%}} enable
  users to test equality and to value match among \code{projects_author}
  objects and as well as between \code{projects_author} objects and unclassed
  numbers/characters. When testing or matching against a numeric vector, the
  \code{projects_author} object is first coerced to an integer with the
  \code{as.integer()} method described above. When testing or matching
  against a character vector, the character vector is validated against the
  \code{\link{authors}()} table.
}

\examples{
#############################################################################
# SETUP
old_home <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
Sys.setenv(HOME = temp_dir)
setup_projects(path = temp_dir)
new_author("chuck", "jonesman", id = 33)
new_author("Hattie", "Hatsman", id = 45)
#############################################################################

jones <- projects_author("33: Jones")

jones

as.integer(jones) # 33

jones == 33       # TRUE
jones == 10       # FALSE
jones != 33       # FALSE

jones \%in\% c(20:40)     # TRUE
match(jones, c(31:40))  # 3

# Comparing a projects_author object to a character vector results in the
# character strings being validated against the authors() table. Then, the id
# numbers are compared.
jones == c("jOnES", "hat")   # TRUE FALSE

#############################################################################
# Cleanup (or just restart R)
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
\seealso{
\code{\link{Ops}}; \code{\link[methods]{Methods_for_Nongenerics}}.
}
