% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{probspace.default}
\alias{probspace.default}
\title{Probability Spaces
Forms a probability space from a set of outcomes and (optional) vector of probabilities.}
\usage{
\method{probspace}{default}(x, probs, ...)
}
\arguments{
\item{x}{a vector, data frame, or list of outcomes.}

\item{probs}{a vector of non-negative weights of the same length as \code{outcomes}}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
If \code{outcomes} is a vector or data frame, then the value is a data frame with an added \code{probs} column.  If \code{outcomes} is a list, then the value is a list with components \code{outcomes} (the supplied list) and a \code{probs} component.
}
\description{
Probability Spaces
Forms a probability space from a set of outcomes and (optional) vector of probabilities.
}
\details{
The elements of \code{probs} will be normalized to ensure that their sum is one.  If \code{probs} is not specified, then the equally likely model is assumed in which every outcome has the same probability.
}
\examples{
R <- rolldie(3)
probspace(R)
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
