% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_image.R
\name{pd_image}
\alias{pd_image}
\alias{prism_image}
\title{Quick spatial image of prism data}
\usage{
pd_image(pd, col = "heat")

prism_image(prismfile, col = "heat")
}
\arguments{
\item{pd, prismfile}{the name of a single file to be plotted, this is most
easily found through \code{\link[=prism_archive_ls]{prism_archive_ls()}} or \code{\link[=prism_archive_subset]{prism_archive_subset()}}.}

\item{col}{the color pattern to use.  The default is heat, the other valid
option is "redblue".}
}
\value{
Invisibly returns \code{gg} object of the image.
}
\description{
\code{pd_image()} makes a spatial image plot of the specified prism
data (single variable and time step.). It is meant for rapid visualization,
but more detailed plots will require other methods.

\code{prism_image()} is the deprecated version of \code{pd_image()}.
}
\examples{
\dontrun{
get_prism_dailys(
  type = "tmean",
  minDate = "2013-06-01",
  maxDate = "2013-06-14",
  keepZip = FALSE
)

# get June 5th
pd <- prism_archive_subset("tmean", "daily", dates = "2013-06-05")

# and plot it
pd_image(pd)
}

}
\seealso{
\code{\link[=prism_archive_ls]{prism_archive_ls()}}, \code{\link[=prism_archive_subset]{prism_archive_subset()}},
\code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}
}
