% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_highs_solver.R
\name{add_highs_solver}
\alias{add_highs_solver}
\title{Add a \emph{HiGHS} solver}
\usage{
add_highs_solver(
  x,
  gap = 0.1,
  time_limit = .Machine$integer.max,
  presolve = TRUE,
  threads = 1,
  verbose = TRUE,
  control = list()
)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative
and expresses the acceptable deviance from the optimal objective.
For example, a value of 0.01 will result in the solver stopping when
it has found a solution within 1\% of optimality.
Additionally, a value of 0 will result in the solver stopping
when it has found an optimal solution.
The default value is 0.1 (i.e., 10\% from optimality).}

\item{time_limit}{\code{numeric} time limit (seconds) for generating solutions.
The solver will return the current best solution when this time limit is
exceeded. The default value is the largest integer value
(i.e., \code{.Machine$integer.max}), effectively meaning that solver
will keep running until a solution within the optimality gap is found.}

\item{presolve}{\code{logical} attempt to simplify the
problem before solving it? Defaults to \code{TRUE}.}

\item{threads}{\code{integer} number of threads to use for the
optimization algorithm. The default value is 1.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems? Defaults to \code{TRUE}.}

\item{control}{\code{list} with additional parameters for tuning
the optimization process.
For example, \code{control = list(simplex_strategy = 1)} could be used to
set the \code{simplex_strategy} parameter.
See the \href{https://ergo-code.github.io/HiGHS/dev/options/definitions/}{online documentation}
for information on the parameters.}
}
\value{
An updated \code{\link[=problem]{problem()}} object with the solver added to it.
}
\description{
Specify that the \href{https://highs.dev/}{\emph{HiGHS}} software
should be used to solve a conservation planning problem
(Huangfu and Hall 2018). This function can also be used to
customize the behavior of the solver.
It requires the \pkg{highs} package to be installed.
}
\details{
\href{https://highs.dev/}{\emph{HiGHS}} is an open source optimization software.
Although this solver can have comparable performance to the \emph{CBC} solver
(i.e., \code{\link[=add_cbc_solver]{add_cbc_solver()}}) for particular problems and is generally faster
than the \emph{SYMPHONY} based solvers (i.e., \code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}},
\code{\link[=add_lpsymphony_solver]{add_lpsymphony_solver()}}), it can sometimes take much longer than the
\emph{CBC} solver for particular problems. This solver is recommended if
the \code{\link[=add_gurobi_solver]{add_gurobi_solver()}}, \code{\link[=add_cplex_solver]{add_cplex_solver()}}, \code{\link[=add_cbc_solver]{add_cbc_solver()}} cannot
be used.
}
\examples{
\dontrun{
# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()

# create problem
p <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions() \%>\%
  add_highs_solver(gap = 0, verbose = FALSE)

# generate solution
s <- solve(p)

# plot solution
plot(s, main = "solution", axes = FALSE)
}
}
\references{
Huangfu Q and Hall JAJ (2018). Parallelizing the dual revised simplex
method. \emph{Mathematical Programming Computation}, 10: 119-142.
}
\seealso{
Other functions for adding solvers:
\code{\link{add_cbc_solver}()},
\code{\link{add_cplex_solver}()},
\code{\link{add_default_solver}()},
\code{\link{add_gurobi_solver}()},
\code{\link{add_lsymphony_solver}},
\code{\link{add_rsymphony_solver}()}
}
\concept{solvers}
