% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pla.R
\name{pla.drop_blocks}
\alias{pla.drop_blocks}
\title{Drop Blocks}
\usage{
pla.drop_blocks(object, blocks, ...)
}
\arguments{
\item{object}{a pla object.}

\item{blocks}{a list of numeric values indicating the indices of the blocks
that should be removed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
list of the following attributes:
\item{x}{
  a numeric matrix or data frame containing the reduced set of original
  variables.
}
\item{cc_matrix}{
  a numeric matrix or data frame which contains the conditional dispersion
  matrix. Depending on the pla procedure, this is either the conditional
  covariance matrix or the conditional correlation matrix.
}
}
\description{
Used to pass the indices of the blocks we want to discard.
}
\examples{
if(requireNamespace("AER")){
require(AER)
data("OECDGrowth")

pla(OECDGrowth, cor=TRUE, thresholds=0.5)

## we obtain three blocks: (randd), (gdp85,gdp60) and (invest, school,
## popgrowth). Block 1, i.e. the 1x1 block (randd), explains only 5.76\% of
## the overall variance. Hence, discarding this block seems appropriate.

pla_obj = pla(OECDGrowth, cor=TRUE, thresholds=0.5)
pla.drop_blocks(pla_obj, c(1)) ## drop block 1
}

}
