% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetalogistic.R
\name{thetalogistic}
\alias{thetalogistic}
\title{Continuous Theta-Logistic Growth}
\usage{
thetalogistic(times, y, parms)
}
\arguments{
\item{times}{Times points that will return N}

\item{y}{N}

\item{parms}{a vector of logistic growth parameters}
}
\value{
Returns of list of one component (required by \code{ode}).
}
\description{
A function for continuous theta-logistic growth, for use with \code{ode} in
the \code{deSolve} package.
}
\details{
The user does not put these directly into this function, but rather uses
\code{ode} in the \code{deSolve} package. See \code{ode} in the
\code{deSolve} package.
}
\examples{

library(deSolve)
p <- c(r=1,alpha=.01, theta=.5)
time <- seq(1,10, by=.1)
initialN <- 10
out <- ode(y=initialN, times=time, func=thetalogistic, parms=p)
plot(time, out[,-1], type='l')

}
\references{
Sibly, R.M., Barker, D., Denham, M.C., Hone, J., and Pagel, M.
(2005) On the regulation of populations of mammals, birds, fish, and
insects. \emph{Science}, \bold{309}, 607--610.

Stevens, M.H.H. (2009) \emph{A Primer of Ecology with R}. Use R! Series.
Springer.
}
\seealso{
\code{\link{clogistic}}
}
\author{
Hank Stevens (HStevens@muohio.edu)
}
\keyword{methods}
