% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_tools.R
\name{pref_pop}
\alias{pref_pop}
\title{Eliminate lowest (or highest) ranked items from preferences.}
\usage{
pref_pop(x, n = 1L, lowest = TRUE, drop = FALSE)
}
\arguments{
\item{x}{A vector of \code{\link{preferences}}.}

\item{n}{The number of times to remove the bottom rank.}

\item{lowest}{If \code{TRUE}, eliminates the lowest ranked item(s) for each
selection.}

\item{drop}{If \code{TRUE}, drops blank preferences from the output.}
}
\value{
A new vector of preferences which is equal to \code{x} but with the least
preferred selection dropped for each selection.
}
\description{
Eliminate lowest (or highest) ranked items from preferences.
}
\examples{
# Remove the lowest ranked item from each preference
pref_pop(preferences(c("a > b > c", "b > c > a")))

# Remove the 2 lowest ranked items
pref_pop(preferences(c("a > b > c > d", "b > c > a > d")), n = 2)

# Remove the highest ranked item instead
pref_pop(preferences(c("a > b > c", "b > c > a")), lowest = FALSE)

# Remove blank preferences that result from popping
pref_pop(preferences(c("a > b", "c", "")), drop = TRUE)
}
