choose.pweibull <-
function(formula, data, criteria="AIC", L.max=5, t=NULL, prec=1e-04, max.iter=1000, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
{ 
if (!inherits(formula, "formula")) {
        if (inherits(formula, "data.frame")) 
            warning("You gave a data.frame instead of a formula.")
        stop("formula is not an object of type formula")
    }
    if (!inherits(data, "data.frame")) {
        if (inherits(data, "formula")) 
            warning("You gave a formula instead of a data.frame.")
        stop("data is not an object of type data.frame")
    }
    if (missing(formula)) 
        stop("Missing formula")
    if (missing(data)) 
        stop("Missing data")
    mf <- model.frame(formula, data)
    Y <- mf[[1]]
    if (!inherits(Y, "Surv")) 
        stop("left hand side not a survival object")
    X1 <- model.matrix(formula, data)
    x <- X1[, -1, drop = FALSE]
    time <- Y[, 1]
    delta <- Y[, 2]
    if (is.null(prec)) 
        stop("prec must be specified")
    if (is.null(max.iter)) 
        stop("max.iter must be specified")
    if (!is.logical(lambda.identical))
        stop("lambda.identical must be TRUE or FALSE")
    if (!is.logical(alpha.identical))
        stop("alpha.identical must be TRUE or FALSE")
    if(alpha.fixed!=FALSE){if(alpha.fixed<=0) stop("alpha.fixed must be FALSE or a positive number")}
    if(!is.null(t)){
t=c(t); if(!is.vector(t)) stop("t must be a vector")
if (!isTRUE(all.equal(0, t[1]))) 
         stop("first element of t should be 0")
if (is.unsorted(t)) 
        stop("t should be in increasing order")}
    time <- c(time)
    delta <- c(delta)
    max.iter <- round(max.iter)
    if (length(time) != length(delta)) 
        stop("t and delta don't have the same length")
    if (prec > 1) 
        stop("prec is too high")
    if (max.iter <= 0) 
        stop("max.iter at least 1")
    if(!any(criteria==c("AIC","BIC")))
        stop("criteria should be AIC or BIC")
L.max=round(L.max)
if(!is.numeric(L.max)) stop("L.max should be a integer")
if(is.null(t))
{
crit=rep(NA, L.max)
aux.min=c()
for(i in 1:L.max)
{
aux=fit.pweibull(Surv(time, delta)~x[,,drop=FALSE], data=data, t=t, L=i, lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed)
crit[i]=aux$"AIC"
if(criteria=="BIC") crit[i]=aux$"BIC"
if(which.min(crit[1:i])==i) aux.min=aux
}
rownames(aux.min$estimate)[1:ncol(x)]=colnames(x)
names(crit)=paste("L=",1:L.max,sep="")
aux.min$L.sel=as.vector(which.min(crit))
if(criteria=="AIC") aux.min$"AIC.L"=crit
if(criteria=="BIC") aux.min$"BIC.L"=crit
}
if(!is.null(t))
{
aux=fit.pweibull(Surv(time, delta)~x[,,drop=FALSE], data=data, t=t, lambda.identical=lambda.identical, alpha.identical=alpha.identical, alpha.fixed=alpha.fixed)
aux.min=aux
aux.min$"AIC.L"=aux$"AIC"
if(criteria=="BIC") aux.min$"BIC.L"=aux$"BIC"
aux.min$"L.sel"=length(t)-1
}
aux.min
}
