% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{convertNodePair}
\alias{convertNodePair}
\title{Convert node pair \eqn{(i,j)}}
\usage{
convertNodePair(i, j, n, directed)
}
\arguments{
\item{i}{Node \eqn{i} : \eqn{i\in \{1, \ldots, n\} }}

\item{j}{Node \eqn{j} : \eqn{j\in \{1, \ldots, n\} }}

\item{n}{Total number of nodes,  \eqn{1\le i \le n}}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
Index corresponding to the node pair
}
\description{
Convert node pair \eqn{(i,j)} into an index in \eqn{\{1,\dots,N\}} where \eqn{N=n(n-1)} (directed case) or \eqn{N=n(n-1)/2} (undirected case).
}
\details{
Interacting individuals \eqn{(i,j)} must be encoded into integer values in  \eqn{\{1,\dots,N\}} in describing the data. 
 
\describe{
  \item{\strong{Directed case :}}{
    \itemize{
      \item The node pair \eqn{(i,j)} with \eqn{(i\neq j)} is converted into the index \eqn{(i-1)*(n-1)+j-(i<j)}
    }
  }
  \item{\strong{Undirected case :}}{
    \itemize{
      \item The node pair \eqn{(i,j)} with \eqn{(i\neq j)} is converted into the index \eqn{(2*n-i)*(i-1)/2 +j-i}
    }
  }
}

The number of possible node pairs is
    \itemize{
      \item \eqn{N = n*(n-1)} for the directed case
      \item \eqn{N = n*(n-1)/2}  for the undirected case
    }
which corresponds to the range of values for \code{data$type.seq}
}
\examples{
# Convert the node pair (3,7) into an index, where the total number of nodes is 10,
# for directed and undirected interactions

i <- 3
j <- 7
n <- 10

directedIndex <- convertNodePair(i,j,n,TRUE)
undirectedIndex <- convertNodePair(i,j,n,FALSE)

}
