% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBalanceSite.R
\name{checkBalanceSite}
\alias{checkBalanceSite}
\title{Checking of site-specific covariate balance before and after weighting}
\usage{
checkBalanceSite(data, indA, indX, truncP = 1)
}
\arguments{
\item{data}{An individual-level dataset in the form of R data frame.}

\item{indA}{A column name indicating the exposure/treatment variable.}

\item{indX}{A vector of column names indicating the baseline covariates to be included in the propensity score model.}

\item{truncP}{A value between 0 and 1 indicating the percentile used for weight truncation. The default is 1, corresponding to no weight truncation.}
}
\value{
A data frame of balance checking results. Each covariate has a row of six numbers: the mean of this covariate for exposed individuals in the original sample, for unexposed individuals in the original sample, for exposed individuals in the weighted sample with conventional weights, for unexposed individuals in the weighted sample with conventional weights, for exposed individuals in the weighted sample with stabilized weights, and for unexposed individuals in the weighted sample with stabilized weights.
}
\description{
This function checks for site-specific covariate balance before and after weighting using the mean of baseline covariates in the original unweighted and the inverse probability weighted samples. A logistic regression model is used to estimate the propensity scores with an option to do weight truncation. This is a function for data-contributing sites.
}
\examples{
#load an example dataset site1.RData in the package
#site1 contains individual-level data of data-contributing site 1
data(site1)
#data-contributing site 1 checks covariate balance before and after weighting,
#with logistic propensity score model A~X1+X2+X3+X4+X5
#no weight truncation
checkBalanceSite(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=1)
#with truncation: set weights larger than the 90\% quantile of original weights to the 90\% quantile
checkBalanceSite(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=0.9)

}
