% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.power.anova.R
\name{design.anova}
\alias{design.anova}
\title{Define an ANOVA Design}
\usage{
design.anova(
  between = list(),
  within = list(),
  default_within_correlation = 0,
  save_input_as = NULL,
  silent_load = FALSE
)
}
\arguments{
\item{between}{list, between-subjects factors including its levels}

\item{within}{list, within-subjects factors including its levels}

\item{default_within_correlation}{numeric, default within-subjects correlation the correlation
matrix is populated with (for designs including
within-subjects factors)}

\item{save_input_as}{character, file name prefix of the files the input values entered by
the user are save to. File names are constructed as
paste0(save_input_as,"_cor_matrix.csv") and
paste0(save_input_as,"_means_and_sds.csv")}

\item{silent_load}{boolean, FALSE (default): always show input dialogs (even if data was successfully
loaded from a file); TRUE: show input dialogs only if file did not yet exist
and break with error if data from file does not match the design}
}
\value{
object of type design.anova
}
\description{
Constructs an "design.anova" object required by the \code{\link{boot.power.anova}} function.
}
\details{
Based on the supplied within-subjects factors and between-subjects factors, this function
constructs all conditions of the ANOVA design and opens two dialog windows querying for
the expected correlation matrix and cell means (+ standard deviations) for all conditions.

The first dialog window queries for the correlation matrix of the conditions. If you have
a pure between-subjects design, you may instantly close this window. Otherwise, enter the
expected correlations between all conditions that include within-subjects manipulations.
Using the "default_within_correlation" parameter, a default value can be set. You should
fill in only the lower triangle of the correlation matrix and only the values not containing
NAs.

The second dialog window queries for the means and standard deviations expected for each
condition.

Use the "save_input_as" parameter in order to define a file name prefix of the files where
the function saves your input values. This will populate the dialog windows with the saved
values on the next execution of this function. If the parameter is NULL, input values will
not be saved. NOTE: You must delete the respective files if you want to change the design.
}
\examples{
\dontrun{
design <- design.anova(
   between = list(age = c("young","old"),
                  sex = c("male","female")),
   within = list(condition = c("cond1","cond2","cond3")),
   default_within_correlation = 0.7,
   save_input_as = "myexp1",
   silent_load = T
)
}

}
\seealso{
\code{\link{boot.power.anova}}
}
