% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmFordsAlpha.R
\name{genFordsAlphaTree}
\alias{genFordsAlphaTree}
\title{Generation of rooted binary trees under Ford's alpha model}
\usage{
genFordsAlphaTree(n, ALPHA)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0. \cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format,
the number of leaves must be at least 2 since there must be at
least one edge.}

\item{ALPHA}{Numeric value >=0 and <=1 which specifies the probabilities of
picking an inner or a leaf edge. For certain choices of
\code{ALPHA} Ford's alpha model coincides with known models:\cr
\itemize{
\item \code{ALPHA} = 0: Yule model \cr
\item \code{ALPHA} = 1/2: PDA model (all phylogenies equally probable) \cr
\item \code{ALPHA} = 1: Caterpillar with \code{n} leaves
}}
}
\value{
\code{genFordsAlphaTree} A single tree of class \code{phylo} is
returned.
}
\description{
\code{genFordsAlphaTree} - Generates a rooted binary tree in
\code{phylo} format with the given number of \code{n} leaves under Ford's
alpha model.
Ford's alpha model is not a rate-based evolutionary (tree)
construction and thus cannot generate edge lengths, only a topology.
Instead, it works as follows: The idea is to start with a cherry and
incrementally increase the size of the tree by adding a new leaf with
a leaf edge to any edge (inner or leaf edge), one at a time.
Given a tree with i leaves, then each of the i-1 inner edges (includes
an additional root edge) is chosen with probability
\code{ALPHA}/(i-\code{ALPHA}).
Each of the i leaf edges is chosen with probability
(1-\code{ALPHA})/(i-\code{ALPHA}).
}
\examples{
genFordsAlphaTree(n = 5, ALPHA = 0.3)
}
\references{
\itemize{
\item D. J. Ford. Probabilities on cladograms: introduction to the alpha
model, 2005. \cr
\item G. Kaur, K. P. Choi, and T. Wu. Distributions of cherries and pitchforks
for the Ford model. Theoretical Population Biology, 149:27–38, 2023.
}
}
