% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curv.R
\name{plot_inter}
\alias{plot_inter}
\title{Display a Spatial Interaction Function}
\usage{
plot_inter(fun = "e", span, beta, limit = span * 5)
}
\arguments{
\item{fun}{spatial interaction function. Options are "p"
(pareto, power law) or "e" (exponential).
For pareto the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
For "exponential" the interaction is defined as:
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user
(\code{beta} and \code{span}).}

\item{span}{distance where the density of probability of the spatial
interaction function equals 0.5.}

\item{beta}{impedance factor for the spatial interaction function.}

\item{limit}{maximum distance used to retrieved \code{x} points, in
map units.}
}
\value{
a plot
}
\description{
Display a spatial interaction function.
}
\examples{
plot_inter(fun = "e", span = 2000, beta = 2, limit = 4000)
plot_inter(fun = "p", span = 2000, beta = 2, limit = 20000)
}
