% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_params.R
\name{match_params}
\alias{match_params}
\title{Find matching node names}
\usage{
match_params(post, params, type = "base_index", auto_escape = TRUE)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{params}{A vector of regular expressions specifying the nodes to match.
Accepts multi-element vectors to match more than one node at a time.
See examples and \code{vignette("pattern-matching")} for more details.}

\item{type}{Format of returned matches; only two options are accepted:
\itemize{
\item \code{type = "base_only"} to return only the unique node names (without indices).
\item \code{type = "base_index"} (the default) to return the node names with indices included.
}}

\item{auto_escape}{Automatically escape \code{"["} and \code{"]"} characters for pattern matching?
\code{FALSE} will treat \code{"["} and \code{"]"} as special regular expression characters (unless explicitly escaped by user),
\code{TRUE} will treat these symbols as plain text to be matched.
It is generally recommended to keep this as \code{TRUE} (the default),
unless you are performing complex regex searches that require the
\code{"["} and \code{"]"} symbols to be special characters.}
}
\value{
A character vector with all node names in \code{post} that match \code{params}, formatted as requested by \code{type}..
If no matches are found, an error will be returned with
the base node names found in \code{post} to help the next try.
}
\description{
Returns all the node names stored in a \code{\link[coda:mcmc.list]{mcmc.list}}
object that match a provided string.
}
\details{
This function is called as one of the first steps in many of the more downstream
functions in this package. It is thus fairly important to get used to
how the regular expressions work. This function can be used directly to hone in on the correct regular expression.
See the examples below.
}
\examples{
# load example mcmc.list
data(cjs)

# these produce same output b/c of regex pattern matching
match_params(cjs, params = c("b0", "b1"))
match_params(cjs, params = c("b"))

# return only base names, not indices as well
match_params(cjs, params = "b", type = "base_only")

# force a match to start with B
match_params(cjs, "^B")

# force a match to end with 0
match_params(cjs, "0$")

# use a wild card to get b0[3] and b1[3]
match_params(cjs, "b.[3]")

# repeat a wild card
match_params(cjs, "s.+0")

# turn off auto escape to use [] in regex syntax rather than matching them as text
match_params(cjs, params = "[:digit:]$", auto_escape = FALSE)

# pass a dot to match all (same as get_params)
match_params(cjs, ".")
}
