% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.r
\name{info_table}
\alias{info_table}
\title{Create a table summarizing missing data or ploidy information of a genind or
genclone object}
\usage{
info_table(
  gen,
  type = c("missing", "ploidy"),
  percent = TRUE,
  plot = FALSE,
  df = FALSE,
  returnplot = FALSE,
  low = "blue",
  high = "red",
  plotlab = TRUE,
  scaled = TRUE
)
}
\arguments{
\item{gen}{a \link[adegenet:genind-class]{genind} or \linkS4class{genclone} object.}

\item{type}{\code{character}. What information should be returned. Choices
are "missing" (Default) and "ploidy". See Description.}

\item{percent}{\code{logical}. (ONLY FOR \code{type = 'missing'}) If
\code{TRUE} (default), table and plot will represent missing data as a
percentage of each cell. If \code{FALSE}, the table and plot will represent
missing data as raw counts. (See details)}

\item{plot}{\code{logical}. If \code{TRUE}, a simple heatmap will be
produced. If \code{FALSE} (default), no heatmap will be produced.}

\item{df}{\code{logical}. If \code{TRUE}, the data will be returned as a long
form data frame. If \code{FALSE} (default), a matrix with samples in rows
and loci in columns will be returned.}

\item{returnplot}{\code{logical}. If \code{TRUE}, a list is returned with two
elements: \code{table} - the normal output and \code{plot} - the ggplot
object. If \code{FALSE}, the table is returned.}

\item{low}{\code{character}. What color should represent no missing data or
lowest observed ploidy? (default: "blue")}

\item{high}{\code{character}. What color should represent the highest amount
of missing data or observed ploidy? (default: "red")}

\item{plotlab}{\code{logical}. (ONLY FOR \code{type = 'missing'}) If
\code{TRUE} (default), values of missing data greater than 0\% will be
plotted. If \code{FALSE}, the plot will appear un-appended.}

\item{scaled}{\code{logical}. (ONLY FOR \code{type = 'missing'}) This is for
when \code{percent = TRUE}. If \code{TRUE} (default), the color specified
in \code{high} will represent the highest observed value of missing data.
If \code{FALSE}, the color specified in \code{high} will represent 100\%.}
}
\value{
a matrix, data frame (\code{df = TRUE}), or a list (\code{returnplot
  = TRUE}) representing missing data per population (\code{type = 'missing'})
  or ploidy per individual (\code{type = 'ploidy'}) in a \link[adegenet:genind-class]{genind}
  or \linkS4class{genclone} object.
}
\description{
Create a table summarizing missing data or ploidy information of a genind or
genclone object
}
\details{
Missing data is accounted for on a per-population level.\cr
  Ploidy is accounted for on a per-individual level.

  \subsection{For type = 'missing'}{
  This data is potentially useful for identifying areas of systematic missing
  data. There are a few caveats to be aware of. \itemize{ \item
  \strong{Regarding counts of missing data}: Each count represents the number
  of individuals with missing data at each locus. The last column, "mean" can
  be thought of as the average number of individuals with missing data per
  locus. \item \strong{Regarding percentage missing data}: This percentage is
  \strong{relative to the population and locus}, not to the entire data set.
  The last column, "mean" represents the average percent of the population
  with missing data per locus. }}
  \subsection{For type = 'ploidy'}{
  This option is useful for data that has been imported with mixed ploidies.
  It will summarize the relative levels of ploidy per individual per locus.
  This is simply based off of observed alleles and does not provide any
  further estimates.}
}
\examples{
data(nancycats)
nancy.miss <- info_table(nancycats, plot = TRUE, type = "missing")
data(Pinf)
Pinf.ploid <- info_table(Pinf, plot = TRUE, type = "ploidy")

}
\author{
Zhian N. Kamvar
}
\keyword{missing}
\keyword{ploidy}
