% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popkin_af.R
\name{popkin_af}
\alias{popkin_af}
\title{Estimate coancestry from an allele frequency matrix and subpopulation assignments}
\usage{
popkin_af(
  P,
  subpops = NULL,
  loci_on_cols = FALSE,
  mem_factor = 0.7,
  mem_lim = NA,
  want_M = FALSE,
  m_chunk_max = 1000
)
}
\arguments{
\item{P}{\code{m}-by-\code{n} matrix of individual-specific allele frequencies, which should have values between \verb{[0, 1]} (range is not strictly required) or \code{NA} for missing data.}

\item{subpops}{The length-\code{n} vector of subpopulation assignments for each individual.
If \code{NULL}, every individual is effectively treated as a different population.}

\item{loci_on_cols}{If \code{TRUE}, \code{P} has loci on columns and individuals on rows; if \code{FALSE} (default), loci are on rows and individuals on columns.}

\item{mem_factor}{Proportion of available memory to use loading and processing data.
Ignored if \code{mem_lim} is not \code{NA}.}

\item{mem_lim}{Memory limit in GB, used to break up data into chunks for very large datasets.
Note memory usage is somewhat underestimated and is not controlled strictly.
Default in Linux is \code{mem_factor} times the free system memory, otherwise it is 1GB (Windows, OSX and other systems).}

\item{want_M}{If \code{TRUE}, includes the matrix \code{M} of non-missing pair counts in the return value, which are sample sizes that can be useful in modeling the variance of estimates.
Default \code{FALSE} is to return the relatedness matrix only.}

\item{m_chunk_max}{Sets the maximum number of loci to process at the time.
Actual number of loci loaded may be lower if memory is limiting.}
}
\value{
If \code{want_M = FALSE}, returns the estimated \code{n}-by-\code{n} coancestry matrix only.
If \code{P} has names for the individuals, they will be copied to the rows and columns of this coancestry matrix.
If \code{want_M = TRUE}, a named list is returned, containing:
\itemize{
\item \code{coancestry}: the estimated \code{n}-by-\code{n} coancestry matrix
\item \code{M}: the \code{n}-by-\code{n} matrix of non-missing pair counts (see \code{want_M} option).
}
}
\description{
Given the individual-specific allele frequencies of \code{n} individuals, this function returns the \code{n}-by-\code{n} coancestry matrix.
This function is the analog of \code{\link[=popkin]{popkin()}} for allele frequencies rather than genotypes, and as a consequence estimates coancestry instead of kinship.
These coancestry estimates are unbiased if the true allele frequencies are provided, but may be less accurate when the allele frequencies themselves are estimated.
This function is intended for cases where allele frequencies, but not individual genotypes, are available; otherwise it is best to use the individual genotypes and \code{\link[=popkin]{popkin()}}.
An application of interest is the allele frequency matrices from admixture models, in which case the columns correspond to subpopulations rather than individuals, and \code{subpops = NULL} is an acceptable choice.
}
\examples{
# a matrix of random uniform allele frequencies
# (unstructured, unlike real data)
P <- matrix( runif( 9 ), nrow = 3 )

coancestry <- popkin_af( P )

}
\seealso{
\code{\link[=popkin]{popkin()}} for kinship estimation from genotype matrices.
}
