% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hudsonia}
\alias{hudsonia}
\title{Projection matrices for mountain golden heather}
\format{
A list of 4 matrices from 1985-1988
}
\source{
Table 6.7 in Morris and Doak 2002.  The original data is from Frost
1990.
}
\usage{
hudsonia
}
\description{
Projection matrices for the mountain golden heather (\emph{Hudsonia montana})
for years 1985 through 1988 with 6 size classes: seeds, seedlings, and 4 size
classes divided by plant area.
}
\examples{
hudsonia
sapply(hudsonia, lambda)
## mean matrix
x <- mean(hudsonia)
image2(x, mar = c(1, 4, 5.5, 1))
title("Hudsonia mean matrix", line = 2.5)
lambda(x)
# variance
var2(hudsonia)
}
\references{
Morris, W. F., and D. F. Doak. 2002. Quantitative conservation
biology: Theory and practice of population viability analysis. Sinauer,
Sunderland, Massachusetts, USA.
}
\keyword{datasets}
