% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolVIM.R
\name{poolVIM}
\alias{poolVIM}
\title{after the Actual Impurity Reduction Importance is computed with a Random Forest, pvalues from different probes or SNPs belonging to the same gene can be aggregated in order to obtain a single pvalue for that gene. Correlation between probes can also be taken into account.}
\usage{
poolVIM(rf, genenames, x, method = "Tippett", adjust)
}
\arguments{
\item{rf}{a ranger object with "importance="impurity_corrected"}

\item{genenames}{a vector of the name of the gene to which each probe or SNP belongs, it has to be of size dim(x)[1]}

\item{x}{design matrix used by the random forest}

\item{method}{one of Tippett, Fisher, Kost, EBM}

\item{adjust}{"no" / "yes" depending if correlation has to be taken into account}
}
\description{
after the Actual Impurity Reduction Importance is computed with a Random Forest, pvalues from different probes or SNPs belonging to the same gene can be aggregated in order to obtain a single pvalue for that gene. Correlation between probes can also be taken into account.
}
\examples{
n <- 250
x=replicate(50, runif(n))
dat <- data.frame(y = factor(rbinom(n, 1, .5)), x)
library(ranger)
rf <- ranger(y ~ ., dat, importance = "impurity_corrected",num.trees=100)
genenames=colnames(x)=rep(c("G1","G2"),50/2)
poolVIM(rf,genenames,x,method="Fisher",adjust="no")

}
