% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{indReads}
\alias{indReads}
\title{Reads contributed by each individual}
\usage{
indReads(np, coverage, probs)
}
\arguments{
\item{np}{an integer specifying how many individuals were pooled.}

\item{coverage}{a vector containing the total depth of coverage of a given
pool. Each entry of the vector represents a different site.}

\item{probs}{a matrix containing the probability of contribution of each
individual. This matrix can be obtained with the \code{indProbs} function.}
}
\value{
a matrix with the number of reads contributed by each individual
towards the coverage of its pool. Each row of the matrix is a different
individual and each column a different site.
}
\description{
This function simulates the contribution, in terms of reads, of each
individual of a given pool. Please note that this function works for a single
pool and should not be directly applied to situations where multiple pools
were used.
}
\examples{
# probability of contribution for 10 individuals at 5 sites
probs <- indProbs(np = 10, nSNPs = 5, pError = 100)

# simulate the number of reads contributed, assuming 10x coverage for each site
indReads(np = 10, coverage = rep(10, 5), probs = probs)

}
