% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{proj_polysph}
\alias{proj_polysph}
\title{Projection onto the polysphere}
\usage{
proj_polysph(x, ind_dj)
}
\arguments{
\item{x}{a matrix of size \code{c(n, sum(d) + r)}.}

\item{ind_dj}{\code{0}-based index separating the blocks of spheres that
is computed with \code{\link{comp_ind_dj}}.}
}
\value{
A matrix of size \code{c(n, sum(d) + r)} with the projected points.
}
\description{
Projects points on \eqn{\mathbb{R}^{d_1 + \cdots + d_r + r}}
onto the polysphere \eqn{\mathcal{S}^{d_1} \times \cdots \times
\mathcal{S}^{d_r}} by normalizing each block of \eqn{d_j} coordinates.
}
\examples{
# Example on (S^1)^2
d <- c(1, 1)
x <- rbind(c(2, 0, 1, 1))
proj_polysph(x, ind_dj = comp_ind_dj(d))
}
