% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poison_frog_palettes.R
\name{poison_palette}
\alias{poison_palette}
\title{Plot and print poison frog color palettes.}
\usage{
poison_palette(
  name,
  n = NULL,
  type = c("discrete", "continuous"),
  direction = 1,
  alpha = NULL,
  return = c("plot", "vector")
)
}
\arguments{
\item{name}{Character. Name of poison frog palette (one of \code{poison_palettes_names()}).}

\item{n}{Integer (optional). Number of colours to use. Defaults to the
palette length (max. n = 5) for \code{type = "discrete"} and 256 for \code{type = "continuous"}.}

\item{type}{Either \code{"discrete"} or \code{"continuous"}.}

\item{direction}{Integer. \code{1} for forward, \code{-1} for reversed order.}

\item{alpha}{Optional numeric in \verb{[0, 1]}. Uniform transparency applied to
all colours.}

\item{return}{Either \code{"plot"} (default) to show a tile plot with hex labels,
or \code{"vector"} to return a character vector of hex colours.}
}
\value{
If \code{return = "plot"}, a ggplot2 object. If \code{return = "vector"},
a character vector of hex colours.
}
\description{
Visualize colors and print hexcodes from a poison frog color palette.
}
\examples{
# Show a palette as tiles (default)
poison_palette("Ramazonica")

# Reverse order and show only 4 colours
poison_palette("Ramazonica", n = 4, direction = -1)

# Get a vector with the palette hex codes
cols <- poison_palette("Ramazonica", return = "vector")

# Continuous gradient preview (16 swatches)
poison_palette("Osotokiki", type = "continuous", n = 16)

}
