% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_repatriate_occupation_from_address}
\alias{general_repatriate_occupation_from_address}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_repatriate_occupation_from_address(directory, regex)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{occupation} and \code{addresses}.}

\item{regex}{Regex to use for the task provided as a character string.}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{occupation} and \code{addresses}.
}
\description{
For some raw Scottish post office general directory entries occupation
information lives in the \code{addresses} column as a result of parsing errors.
\code{general_repatriate_occupation_from_address} attempts to move this
information to the appropriate destination: the \code{occupation} column.
}
