% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nm_output.R
\name{read_nm_output}
\alias{read_nm_output}
\title{Read NONMEM output}
\usage{
read_nm_output(
  rundir = getwd(),
  runname = basename(normalizePath(rundir)),
  lst.file = file.path(rundir, sprintf("\%s.lst", runname)),
  ext.file = file.path(rundir, sprintf("\%s.ext", runname)),
  shk.file = file.path(rundir, sprintf("\%s.shk", runname)),
  phi.file = file.path(rundir, sprintf("\%s.phi", runname)),
  phm.file = file.path(rundir, sprintf("\%s.phm", runname)),
  cov.file = file.path(rundir, sprintf("\%s.cov", runname)),
  cor.file = file.path(rundir, sprintf("\%s.cor", runname)),
  bootstrap.file = file.path(rundir, "bootstrap", sprintf("raw_results_\%s.csv",
    runname)),
  meta = read_meta(file.path(rundir, "meta.yaml")),
  th_names = meta$namemap$theta,
  om_names = meta$namemap$omega,
  sg_names = meta$namemap$sigma,
  use.vcov = FALSE,
  ...
)
}
\arguments{
\item{rundir}{Name of the directory containing the output files.}

\item{runname}{Name of the run (i.e., corresponds to the basename of the output files).}

\item{lst.file}{Name of the .lst file (standard NONMEM output file).}

\item{ext.file}{Name of the .ext file (standard NONMEM output file).}

\item{shk.file}{Name of the .shk file (standard NONMEM output file).}

\item{phi.file}{Name of the .phi file (standard NONMEM output file).}

\item{phm.file}{Name of the .phm file (standard NONMEM output file).}

\item{cov.file}{Name of the .cov file (standard NONMEM output file).}

\item{cor.file}{Name of the .cor file (standard NONMEM output file).}

\item{bootstrap.file}{Name of the file containing bootstrap results (typically produced by PsN).}

\item{meta}{Object containing meta information that accompanies the model
(e.g., names of the \code{THETA}, \code{OMEGA} and \code{SIGMA} parameters).}

\item{th_names}{A character vector containing the names associated with the
\code{THETA} parameters in their respective order (e.g., \code{THETA(1)} is given the
name \code{th_names[1]}, and so on).}

\item{om_names}{A character vector containing the names associated with the
the \code{OMEGA} matrix diagonal elements, in their respective order (e.g.,
\code{OMEGA(1,1)} is given the name \code{om_names[1]}, and so on).}

\item{sg_names}{A character vector containing the names associated with the
\code{SIGMA} matrix diagonal elements, in their respective order (e.g.,
\code{SIGMA(1,1)} is given the name \code{sg_names[1]}, and so on).}

\item{use.vcov}{Should the default \code{OMEGA} and \code{SIGMA} be on the
variance/covariance scale instead of the SD/correlation scale?}

\item{...}{Additional arguments (ignored).}
}
\value{
A named list with components containing the outputs from the NONMEM
run. Notably, the components \code{th}, \code{om} and \code{sg} contain the final estimates
of the \code{THETA}, \code{SD(ETA)} and \code{SD(EPS)} parameters respectively (\code{SD} means
standard deviation).
}
\description{
Read NONMEM output
}
\details{
All arguments are optional. If a particular output file cannot be
found, then it is simply skipped (and the resulting object won't contain the
components that would normally be read from there).
}
