% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.pmlsprobit}
\alias{predict.pmlsprobit}
\title{Predicted Values and Marginal Effects for Spatial Probit Models}
\usage{
\method{predict}{pmlsprobit}(
  object,
  type = "prob",
  newdata = NULL,
  variables = NULL,
  delta.method = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"pmlsprobit"}.}

\item{type}{Character string specifying the type of prediction.
Use \code{"prob"} for predicted probabilities \eqn{P(Y_i = 1)}, or
\code{"me"} for direct, indirect, and total average marginal effects.}

\item{newdata}{Optional data frame containing variables used for prediction.
If omitted, the fitted values are used.}

\item{variables}{Character vector of covariate names for which marginal
effects are computed using numerical derivatives. Only used if
\code{type = "me"}.}

\item{delta.method}{Logical; if \code{TRUE}, standard errors of the predictions
are computed. Only used if \code{type = "me"}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
If \code{type = "prob"}, a numeric vector of predicted probabilities.
If \code{type = "me"}, a list of matrices containing individual direct,
indirect, and total marginal effects for each covariate.
}
\description{
Computes predicted probabilities or average marginal effects from an object
of class \code{"pmlsprobit"}.
}
\examples{
\donttest{
data(oldcol, package = "spdep")
dat <- COL.OLD
dat$y <- as.numeric(dat$CRIME > 35)

listw <- spdep::nb2listw(COL.nb, style = "W")

set.seed(857489)
mod <- pmlsbp(
  y ~ HOVAL + INC, data = dat, W = listw,
  model = "SAR", grouping = 7,
  mvtnorm_control = list(
    M = 25e2, sim_type = "mc",
    tol = .Machine$double.eps, fast = FALSE
  ),
  na.action = na.omit, spectral = TRUE,
  iterlim = 1e5
)

prob <- predict(mod)
head(prob)
}

}
\seealso{
Partial maximum likelihood estimation is implemented in
\code{\link{pmlsbp}}.
}
