% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_plot.R
\name{calibration_stability}
\alias{calibration_stability}
\title{Plot calibration stability across bootstrap replicates}
\usage{
calibration_stability(
  x,
  calib_args,
  xlim,
  ylim,
  xlab,
  ylab,
  col,
  subset,
  plot = TRUE
)
}
\arguments{
\item{x}{an object produced by \code{\link{validate}} with method = "boot_*" (or \code{\link{boot_optimism}} with method="boot")}

\item{calib_args}{settings for calibration curve (see \code{pmcalibration::pmcalibration}). If unspecified settings
are given by \code{\link{cal_defaults}} with 'eval' set to 100 (evaluate each curve at 100 points between min and max prediction).}

\item{xlim}{x limits (default = c(0,1))}

\item{ylim}{y limits (default = c(0,1))}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{col}{color of lines for bootstrap models (default = grDevices::grey(.5, .3))}

\item{subset}{vector of observations to include (row indices). If dataset is large fitting B curves is demanding. This can be used to select a random subset of observations.}

\item{plot}{if FALSE just returns curves (see value)}
}
\value{
plots calibration (in)stability.
Invisibly returns a list containing data for each curve (p=x-axis, pc=y-axis).
The first element of this list is the apparent curve (original model on original outcome).
}
\description{
A calibration (in)stability plot shows calibration curves for bootstrap
models evaluated on original outcome. A stable model should produce
boot calibration curves that differ minimally from the 'apparent' curve.
}
\examples{
\donttest{
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ ., data=dat, family="binomial")

# internal validation of m1 via bootstrap optimism with 10 resamples
# B = 10 for example but should be >= 200 in practice
m1_iv <- validate(m1, method="boot_optimism", B=10)

calibration_stability(m1_iv)
}
}
\references{
Riley, R. D., & Collins, G. S. (2023). Stability of clinical prediction models developed using statistical or machine learning methods. Biometrical Journal, 65(8), 2200302. doi:10.1002/bimj.202200302
}
