% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{process_heatmap_data}
\alias{process_heatmap_data}
\title{Process/normalize data passed to \code{\link[=Heatmap]{Heatmap()}}}
\usage{
process_heatmap_data(
  data,
  in_form,
  values_by,
  name,
  split_by,
  split_by_sep,
  rows_by,
  rows_by_sep,
  rows_name,
  rows_split_by,
  rows_split_by_sep,
  rows_split_name,
  columns_by,
  columns_by_sep,
  columns_name,
  columns_split_by,
  columns_split_by_sep,
  columns_split_name,
  pie_group_by,
  pie_group_by_sep,
  pie_name,
  rows_data,
  columns_data,
  keep_na,
  keep_empty
)
}
\arguments{
\item{data}{A data frame or matrix containing the data to be plotted.
Based on the \code{in_form}, the data can have the following formats:
\itemize{
\item \code{matrix}: A matrix with rows and columns directly representing the heatmap.
\item \code{long}: A data frame in long format with columns for values, rows, and columns.
\item \code{wide-rows}: A data frame in wide format with columns for heatmap rows and values,
and a single column for heatmap columns.
\item \code{wide-columns}: A data frame in wide format with columns for heatmap columns and values,
and a single column for heatmap rows.
\item \code{auto}: Automatically inferred from the data format.
When \code{data} is a matrix, \code{in_form} is set to \code{"matrix"}. When \code{columns_by} has more than one column,
\code{in_form} is set to \code{"wide-columns"}. When \code{rows_by} has more than one column,
\code{in_form} is set to \code{"wide-rows"}. Otherwise, it is set to \code{"long"}.
}}

\item{in_form}{The format of the data. Can be one of \code{"matrix"}, \code{"long"}, \code{"wide-rows"}, \code{"wide-columns"}, or \code{"auto"}.
Defaults to \code{"auto"}.}

\item{values_by}{A character of column name in \code{data} that contains the values to be plotted.
This is required when \code{in_form} is \code{"long"}. For other formats, the values are pivoted into a column named by \code{values_by}.}

\item{name}{A character string to name the heatmap (will be used to rename \code{values_by}).}

\item{split_by}{A character of column name in \code{data} that contains the split information to split into multiple heatmaps.
This is used to create a list of heatmaps, one for each level of the split.
Defaults to \code{NULL}, meaning no split.}

\item{split_by_sep}{A character string to concat multiple columns in \code{split_by}.}

\item{rows_by}{A vector of column names in \code{data} that contains the row information.
This is used to create the rows of the heatmap.
When \code{in_form} is \code{"long"} or \code{"wide-columns"}, this is requied, and multiple columns can be specified,
which will be concatenated by \code{rows_by_sep} into a single column.}

\item{rows_by_sep}{A character string to concat multiple columns in \code{rows_by}.}

\item{rows_name}{A character string to rename the column created by \code{rows_by}, which will be reflected in the name of the annotation or legend.}

\item{rows_split_by}{A character of column name in \code{data} that contains the split information for rows.}

\item{rows_split_by_sep}{A character string to concat multiple columns in \code{rows_split_by}.}

\item{rows_split_name}{A character string to rename the column created by \code{rows_split_by}, which will be reflected in the name of the annotation or legend.}

\item{columns_by}{A vector of column names in \code{data} that contains the column information.
This is used to create the columns of the heatmap.
When \code{in_form} is \code{"long"} or \code{"wide-rows"}, this is required, and multiple columns can be specified,
which will be concatenated by \code{columns_by_sep} into a single column.}

\item{columns_by_sep}{A character string to concat multiple columns in \code{columns_by}.}

\item{columns_name}{A character string to rename the column created by \code{columns_by}, which will be reflected in the name of the annotation or legend.}

\item{columns_split_by}{A character of column name in \code{data} that contains the split information for columns.}

\item{columns_split_by_sep}{A character string to concat multiple columns in \code{columns_split_by}.}

\item{columns_split_name}{A character string to rename the column created by \code{columns_split_by}, which will be reflected in the name of the annotation or legend.}

\item{pie_group_by}{A character of column name in \code{data} that contains the group information for pie charts.
This is used to create pie charts in the heatmap when \code{cell_type} is \code{"pie"}.}

\item{pie_group_by_sep}{A character string to concat multiple columns in \code{pie_group_by}.}

\item{pie_name}{A character string to rename the column created by \code{pie_group_by}, which will be reflected in the name of the annotation or legend.}

\item{rows_data}{A data frame containing additional data for rows, which can be used to add annotations to the heatmap.
It will be joined to the main data by \code{rows_by} and \code{split_by} if \code{split_by} exists in \code{rows_data}.
This is useful for adding additional information to the rows of the heatmap.}

\item{columns_data}{A data frame containing additional data for columns, which can be used to add annotations to the heatmap.
It will be joined to the main data by \code{columns_by} and \code{split_by} if \code{split_by} exists in \code{columns_data}.
This is useful for adding additional information to the columns of the heatmap.}

\item{keep_na}{Whether we should keep NA groups in rows, columns and split_by variables. Default is FALSE.
FALSE to remove NA groups; TRUE to keep NA groups.
A vector of column names can also be provided to specify which columns to keep NA groups.
Note that the record will be removed if any of the grouping columns has NA and is not specified to keep NA.}
}
\value{
A list containing the processed data and metadata:
\itemize{
\item \code{data}: A list of data frames, one for each level of \code{split_by}. If no \code{split_by} is provided, the name will be \code{"..."}.
Each data frame is in the long format.
\item \code{values_by}: The name of the column containing the values to be plotted.
\item \code{rows_by}: The name of the column containing the row information.
\item \code{rows_split_by}: The name of the column containing the row split information.
\item \code{columns_by}: The name of the column containing the column information.
\item \code{columns_split_by}: The name of the column containing the column split information.
\item \code{pie_group_by}: The name of the column containing the pie group information.
}
}
\description{
This function is used to process the data passed to \code{\link[=Heatmap]{Heatmap()}}.
}
\keyword{internal}
