% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_signifArea}
\alias{plot_signifArea}
\title{Creates a colored surface plot from data frame input.}
\usage{
plot_signifArea(data, view, predictor = NULL, valCI, col = 1, alpha = 0.5, ...)
}
\arguments{
\item{data}{Data frame with plot data. A data frame needs to have a 
column with x values, a column with y values (specified in \code{view}), 
a column with z values (\code{predictor}), and one or two columns with 
CI values (\code{valCI}).}

\item{view}{A vector of length 2 with the names or numbers of the columns 
to plot on the x axis and y axis respectively.}

\item{predictor}{The name of the column in the data frame 
\code{data} that provides the z-values. If data contains more than one 
column besides the x- and y-values, the \code{predictor} should be provided.}

\item{valCI}{The name of the column in the data frame 
\code{data} that provides the CI-values. Alternatively, 
two column names can be provided for the lower and upper CI respectively.}

\item{col}{Color for the nonsignificant areas.}

\item{alpha}{Level of transparency, number between 0 (transparent) and 1 
(no transparency)}

\item{...}{Optional parameters for \code{\link[graphics]{rasterImage}}}
}
\description{
This function uses \code{\link[graphics]{rasterImage}} to 
indicate which points in the surface are not significantly different from 
zero. Note that the shape of these non-significant regions depends on the 
number of data points (often specified with \code{n.grid}).
}
\examples{
# From the package graphics, see help(image):
x <- 10*(1:nrow(volcano))
y <- 10*(1:ncol(volcano))
tmp <- data.frame(value = (as.vector(volcano) - 120), 
    x = 10*rep(1:nrow(volcano), ncol(volcano)), 
    y = 10*rep(1:ncol(volcano), each=nrow(volcano)),
    CI = rep(20, nrow(volcano)*ncol(volcano)))
plotsurface(tmp, view=c('x', 'y'), predictor='value', main='Maunga Whau Volcano')
plot_signifArea(tmp, view=c('x', 'y'), predictor='value', valCI='CI')

# change color:
plotsurface(tmp, view=c('x', 'y'), predictor='value', main='Maunga Whau Volcano')
plot_signifArea(tmp, view=c('x', 'y'), predictor='value', valCI='CI', 
    col='red')
# or completely remove 'nonsignificant' area:
plot_signifArea(tmp, view=c('x', 'y'), predictor='value', valCI='CI', 
    col='white', alpha=1)

}
\seealso{
\code{\link[graphics]{rasterImage}}
}
\author{
Jacolien van Rij
}
