% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeDoses.R
\name{imputeDoses}
\alias{imputeDoses}
\title{Impute Dose Data}
\usage{
imputeDoses(
  data,
  idVar = "id",
  dateVar = "date.dose",
  infusionDoseTimeVar = NULL,
  infusionDoseVar = NULL,
  maxskips = 3
)
}
\arguments{
\item{data}{data.frame; data set with dose information}

\item{idVar}{character string; name of ID variable, defaults to id}

\item{dateVar}{character string; name of date variable, defaults to date.dose}

\item{infusionDoseTimeVar}{character string; name of infusion dose time
variable}

\item{infusionDoseVar}{character string; name of infusion dose variable}

\item{maxskips}{integer; maximum number of missed doses that may be imputed}
}
\value{
data.frame, containing dose data
}
\description{
Use last-observation-carried-forward to impute missing dose values by hour.
}
\details{
Creates skips column
}
\author{
Cole Beck
}
