% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{func_error_handler}
\alias{func_error_handler}
\title{Custom error handler for printing the name of an enclosing function with error}
\usage{
func_error_handler(e, calling_func)
}
\arguments{
\item{e}{A \code{simpleError} - e.g. thrown from \code{tryCatch}}

\item{calling_func}{A character string naming the enclosing function (or closure) for printing
with error messages}
}
\value{
NULL - throws error with custom message
}
\description{
Custom error handler for printing the name of an enclosing function with error
}
\examples{
\dontrun{
f <- function(x) x ^ 2
tryCatch(f("a"), error = function(e) func_error_handler(e, "f"))
# Error in x^2 : non-numeric argument to binary operator
# ---> called from within function: f
}
}

