% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.estimators.R
\name{vcov.estimators}
\alias{vcov.estimators}
\alias{sandwich.vcov}
\alias{score.vcov}
\title{vcov estimators for pim}
\usage{
sandwich.vcov(fitted, X, Y, W, link, poset, ...)

score.vcov(fitted, X, Y, W, link, poset, ...)
}
\arguments{
\item{fitted}{The fitted values (calculated as \code{X \%*\% coef} with
\code{X} the design matrix and \code{coef} the coefficients)}

\item{X}{the design matrix}

\item{Y}{a numeric vector with pseudoresponses}

\item{W}{a numeric vector with weights. If weights are not applicable,
set to \code{NULL} (the default)}

\item{link}{a character vector with the link function}

\item{poset}{a list with the left and right indices. See \code{\link{poset}}
for more information.}

\item{...}{arguments passed to downstream methods.}
}
\value{
the variance-covariance matrix
}
\description{
\code{sandwich.vcov} and \code{score.vcov} are two similar estimators
for the variance-covariance matrix of a probabilistic index model.
These functions are meant to be used within a call to \code{\link{pim}}
as a value for the argument \code{vcov}.
}
\details{
You can create your own estimating functions for the variance-covariance
matrix. To do so, you have to make sure that your function allows for
the exact same arguments. As the function \code{pim.fit} calculates the
fitted values already, there's no need to incorporate the calculation of
these inside the function.
}
\note{
You should only use \code{score.vcov} in combination with an 
identity link
}
\seealso{
\code{\link{sandwich.estimator}} for more information on the
actual fitting process. \code{\link{pim}} for a few examples in how
these are used
}
