% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_detection.R
\name{.getNClusters}
\alias{.getNClusters}
\title{Find resolution for target cluster count}
\usage{
.getNClusters(
  g,
  n_cluster,
  range_min = 0,
  range_max = 6,
  max_steps = 20,
  method = "leiden"
)
}
\arguments{
\item{g}{An igraph graph object with weighted edges}

\item{n_cluster}{Target number of clusters}

\item{range_min}{Minimum resolution to search. Default is 0.}

\item{range_max}{Maximum resolution to search. Default is 6.}

\item{max_steps}{Maximum number of search iterations. Default is 20.}

\item{method}{Community detection method: "leiden" or "louvain". Default is "leiden".}
}
\value{
A list containing:
\itemize{
\item \code{partition}: The community detection result
\item \code{clusters}: Number of clusters found
\item \code{best_resolution}: The resolution parameter used
}
}
\description{
Uses binary search to find a resolution parameter that produces approximately
the target number of clusters.
}
\keyword{internal}
