% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varfreq_expected_mbias.R
\name{varfreq_expected_mbias}
\alias{varfreq_expected_mbias}
\title{Calculate multiplicative bias (observed / actual) in variant prevalence}
\usage{
varfreq_expected_mbias(p_v1, c_ratio)
}
\arguments{
\item{p_v1}{actual variant prevalence (proportion)}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2}
}
\value{
scalar giving the multiplicative bias of variant 1
}
\description{
This function calculates the multiplicative bias of the observed variant proportion
relative to the actual variant proportion. This function assumes that variant 1 is the variant of concern.
This function is specific to the two-variant system.
}
\examples{
varfreq_expected_mbias(p_v1 = 0.1, c_ratio = 1.1)

}
\seealso{
Other variant frequency functions: 
\code{\link{varfreq_cdf_logistic}()},
\code{\link{varfreq_freq_logistic}()},
\code{\link{varfreq_obs_freq}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant frequency functions}
