% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_expected_links_obs_stsl.R
\name{translink_expected_links_obs_stsl}
\alias{translink_expected_links_obs_stsl}
\title{Calculate expected number of observed pairs assuming single-transmission and single-linkage}
\usage{
translink_expected_links_obs_stsl(sensitivity, specificity, rho, M)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}
}
\value{
scalar or vector giving the expected number of linked pairs observed in the sample
}
\description{
This function calculates the expected number of link pairs observed in a sample of size \code{M}.
The single-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is linked by transmission to only one other case \eqn{j} in the population (\eqn{N}).
\item Each case \eqn{i} is linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}
}
\examples{
# perfect sensitivity and specificity
translink_expected_links_obs_stsl(sensitivity=1, specificity=1, rho=0.5, M=100)

translink_expected_links_obs_stsl(sensitivity=0.99, specificity=0.9, rho=1, M=50)

translink_expected_links_obs_stsl(sensitivity=0.99, specificity=0.9, rho=0.5, M=100)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
