% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relR_samplesize_ci.R
\name{relR_samplesize_ci}
\alias{relR_samplesize_ci}
\title{Calculate sample size for detecting differential transmission with uncertainty bounds}
\usage{
relR_samplesize_ci(
  R_a,
  R_b,
  p_a,
  N,
  alpha = 0.05,
  alternative = c("two_sided", "less", "greater"),
  power = 0.8,
  sensitivity = 1,
  specificity = 1,
  overdispersion = NULL,
  nsims = 1000,
  uncertainty_percent = 0.95,
  B = 1000
)
}
\arguments{
\item{R_a}{Numeric (Positive). The assumed R among the group in the
denominator of the ratio. Input value must be greater than 0.}

\item{R_b}{Numeric (Positive). The assumed R among the group in the
numerator of the ratio. Input value must be greater than 0.}

\item{p_a}{Numeric. The proportion of the population in group \code{a}. Must be
between 0 and 1.}

\item{N}{Numeric (Positive). The size of the infected pool. Only one of
\code{rho} or \code{N} should be specified.}

\item{alpha}{Numeric. The desired alpha level. Default: 0.05}

\item{alternative}{Character. Specifies the alternative hypothesis.
Must be: \code{two_sided} (Default), \code{less}, or \code{greater}}

\item{power}{Numeric. The desired power. Must be a value between 0 and 1.
Default: 0.8.}

\item{sensitivity}{Numeric. The sensitivity of the linkage criteria.
Must be between 0 and 1. Default: 1.}

\item{specificity}{Numeric. The specificity of the linkage criteria.
Must be between 0 and 1. Default: 1.}

\item{overdispersion}{Numeric (Positive). An overdispersion parameter, set
if the assumed distribution of the number of edges is negative binomial.
If \code{NULL} the assumed distribution is Poisson (equivalent to an
overdispersion parameter of infinity) Default: \code{NULL} Note that this is
equivalent to setting the overdispersion parameter to \code{Inf}.}

\item{nsims}{The number of inner simulations run per estimate.
Default: 10000}

\item{uncertainty_percent}{The percent of the uncertainty interval.
Default: .95}

\item{B}{The number of outer simulations run to estimate the uncertainty.
Default: 1000}
}
\value{
A vector with three quantities:
\itemize{
\item sample size: Sample size needed achieve desired type I and II error rates
under assumptions. Will return NA and throw a warning if impossible.
\item lower bound: The lower bound of an uncertainty interval
\item upper bound: The upper bound of an uncertainty interval
}
}
\description{
This function assumes you
want to correct for imbalance, if not there is a closed form solution
for the estimated sample size that does not include uncertainty bounds.
(see \code{\link{relR_samplesize}}).
}
