% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_beta.R
\name{beta_core}
\alias{beta_core}
\alias{beta_diss}
\title{Taxonomic (non-phylogenetic) beta diversity}
\usage{
beta_core(x)

beta_diss(x, index.family = "sorensen")
}
\arguments{
\item{x}{an object of class Matrix, where rows are sites and columns are
species.}

\item{index.family}{family of dissimilarity indices, partial match of
"sorensen" or "jaccard".}
}
\value{
\code{beta_core} returns an object of class \code{beta_diss} like the
\code{\link[betapart]{betapart.core}} function. This object can be called by
\code{\link[betapart]{beta.pair}} or \code{\link[betapart]{beta.multi}}.

\code{beta_diss} returns a list with three dissimilarity matrices. See
\code{\link[betapart]{beta.pair}} for details.
}
\description{
Data are assumed to be presence / absence (0 / 1) and all values greater
zero are assumed to reflect presence.
}
\details{
\code{beta_core} is helper function to compute the basic quantities needed
for computing the "sorensen" or "jaccard" index.
}
\examples{
data(africa)
x <- africa$comm
bc <- beta_core(x)
beta_sorensen <- beta_diss(x)
}
\seealso{
\code{\link[betapart]{betapart.core}}, \code{\link[betapart]{betapart}},
\code{\link{phylobeta}}
}
\author{
Klaus Schliep
}
