% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters-mspct.r
\docType{data}
\name{filters.mspct}
\alias{filters.mspct}
\title{Spectral transmittance of diverse optical filters}
\format{
A \code{"filter_mspct"} object containing several
  \code{"filter_spct"}.
}
\usage{
filters.mspct
}
\description{
A collection of transmittance spectra for optical filters and similar
materials from different suppliers. We include under "filters" all
semi-transparent and transparent sheets and films with homogeneous optical
properties. We exclude "screens" such as nets, cloths and perforated films
with heterogeneous optical properties.
}
\details{
The \code{"filter_mspct"} object named \code{filters.mspct} contains
  a collection of \code{"filter_spct"} objects with spectral transmittance
  data for filters and other optical sheet materials such as glass and
  plastic sheets and films.

  The variables in each member spectrum are as follows: \itemize{ \item
  \code{w.length} (nm) \item \code{Tfr} (transmittance expressed as a
  fraction of one) }

  These member objects contain metadata stored as R attributes. Accessors are
  available to the metadata: \code{\link[photobiology]{what_measured}()},
  \code{\link[photobiology]{how_measured}()},
  \code{\link[photobiology]{when_measured}()},
  \code{\link[photobiology]{filter_properties}()} and
  \code{\link[base]{comment}()}.
}
\note{
Please see the help for the indexing vectors for specific details.
}
\examples{
filters.mspct$Schott_UG11
filters.mspct[[1]]

what_measured(filters.mspct$Schott_UG11)
how_measured(filters.mspct$Schott_UG11)
filter_properties(filters.mspct$Schott_UG11)
cat(comment(filters.mspct$Schott_UG11))

names(filters.mspct)

}
\keyword{datasets}
