#' Indexing of greenhouse films from BPI Visqueen
#'
#' Vector of names of member objects containing spectral transmittance data for different films used as
#' greenhouse cladding supplied by BPI Visqueen.
#'
#' @note Individual measurements of single samples, not a specification.
#'   Instrument used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments
#'   Manufacturing Co. Ltd, China) equipped with an integrating sphere. Some of
#'   these film types are no longer produced.
#'
#' @references
#' \verb{https://www.rpc-bpi.com/sector/horticultural-solutions/} (redirected)
#'
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @seealso \code{\link{filters.mspct}}
#'
#' @examples
#' bpi_visqueen_filters
#'
"bpi_visqueen_filters"
