% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_retries}
\alias{run_retries}
\title{run_retries}
\usage{
run_retries(
  model = NULL,
  results = NULL,
  number_of_candidates = 5,
  fraction = 0.1,
  use_initial_estimates = FALSE,
  strictness = "minimization_successful or (rounding_errors and sigdigs >= 0.1)",
  scale = "UCP",
  prefix_name = "",
  ...
)
}
\arguments{
\item{model}{(Model (optional)) Model object to run retries on. The default is NULL.}

\item{results}{(ModelfitResults (optional)) Connected ModelfitResults object. The default is NULL.}

\item{number_of_candidates}{(numeric) Number of retry candidates to run. The default is 5.}

\item{fraction}{(numeric) Determines allowed increase/decrease from initial parameter estimate. Default is 0.1 (10\%)}

\item{use_initial_estimates}{(logical) Use initial parameter estimates instead of final estimates of input model when creating candidate models.}

\item{strictness}{(str) Strictness criteria. The default is "minimization_successful or (rounding_errors and sigdigs >= 0.1)".}

\item{scale}{(str (optional)) Which scale to update the initial values on. Either normal scale or UCP scale.}

\item{prefix_name}{(str (optional)) Prefix the candidate model names with given string}

\item{...}{Arguments to pass to tool}
}
\value{
(RetriesResults) Retries tool results object.
}
\description{
Run retries tool.
}
