% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pom.R
\name{pom}
\alias{pom}
\title{Proportion of Maximum (POM).}
\usage{
pom(data, min = NULL, max = NULL)
}
\arguments{
\item{data}{The vector of data.}

\item{min}{The minimum possible or observed value.}

\item{max}{The maximum possible or observed value.}
}
\value{
Proportion of maximum possible or observed values.
}
\description{
Calculate the proportion of maximum (POM) score given a minimum and maximum
score.
}
\details{
The minimum and maximum score for calculating the proportion of maximum could
be the possible or observed minimum and maximum, respectively. Using the
possible minimum and maximum would yield the proportion of maximum possible
score. Using the observed minimum and maximum would yield the proportion of
minimum and maximum observed score. If the minimum and maximum possible
scores are not specified, the observed minimum and maximum are used.
}
\examples{
# Prepare Data
v1 <- sample(1:9, size = 1000, replace = TRUE)

# Calculate Proportion of Maximum Possible (by specifying the minimum and maximum possible)
pom(v1, min = 0, max = 10)

# Calculate Proportion of Maximum Observed
pom(v1)
}
\seealso{
Other conversion: 
\code{\link{convert.magic}()},
\code{\link{convertHoursAMPM}()},
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()},
\code{\link{percentileToTScore}()}
}
\concept{conversion}
