% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_match.R
\name{direct_match_infra_rank_within_species_helper}
\alias{direct_match_infra_rank_within_species_helper}
\title{Helper: Direct Match Infraspecific Rank within Species}
\usage{
direct_match_infra_rank_within_species_helper(
  df,
  target_df,
  source = "original"
)
}
\arguments{
\item{df}{A tibble containing data for a single matched species.}

\item{target_df}{A tibble representing the threatened species database.}

\item{source}{Character string specifying which database version to use.
Options are:
\itemize{
  \item \code{"original"} (default): Uses the original threatened species database
  \item \code{"updated"}: Uses the updated database with synonyms
}}
}
\value{
A tibble with match results and logical indicator.
}
\description{
Helper function that performs the actual matching of infraspecific ranks
for a single matched species. Automatically handles both original and
updated databases by using the appropriate column name (tag or tag_acc).
}
\details{
The function performs the following steps:
1. Determines which column to use based on use_infraspecies_2
2. Extracts infraspecific ranks from the database for the matched species
3. Standardizes rank names to uppercase
4. Performs exact matching on the rank category
5. Returns matched and unmatched records with boolean indicator
}
\keyword{internal}
