% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{diff_in_medians}
\alias{diff_in_medians}
\title{Calculate difference in medians}
\usage{
diff_in_medians(df, group_col, outcome_col, treatment_value = NULL)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{outcome_col}{The name of the column in df that corresponds to the outcome variable}

\item{treatment_value}{The value of group_col to be considered 'treatment'}
}
\value{
The difference in median outcome between the two groups
}
\description{
This function takes a data frame, and group and outcome column names as input
and returns the difference in median outcome between the two groups
}
\examples{
data <- data.frame(group = c(rep(1, 4), rep(2, 4)),
                   outcome = c(rep(3, 4), rep(5, 4)))

diff_in_medians(df = data,
              group_col = "group",
              outcome_col = "outcome",
              treatment_value = 1)
}
