% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{jpah2016}
\alias{jpah2016}
\title{Dataset of a control study in psychology.}
\format{
A data frame with 38 rows and 8 variables.
}
\usage{
data(jpah2016)
}
\description{
A subset of a control experiment measuring the impulsive approach tendencies toward physical activity or sedentary behaviors.
}
\details{
\itemize{
\item id identifier of the subject.
\item bmi body mass index.
\item age.
\item sex.
\item condition the experimental condition where the task was to approach physical activity and avoid sedentary behavior (ApSB_AvPA), approach sedentarity behavior and avoid physical activity (ApPA_AvSB), and a control condition (control).
\item time pre, post.
\item iapa measure of impulsive approach tendencies toward physical activity (dependant variable).
\item iasb measure of impulsive approach tendencies toward sedentary behavior (dependant variable).
}
}
\references{
Cheval, B., Sarrazin, P., Pelletier, L., & Friese, M. (2016). Effect of retraining approach-avoidance tendencies on an exercise task: A randomized controlled trial. Journal of Physical Activity and Health, 13(12), 1396-1403.
}
\seealso{
Other dataset: 
\code{\link{attentionshifting_design}},
\code{\link{attentionshifting_signal}},
\code{\link{emergencycost}}
}
\concept{dataset}
