% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputLab.R
\name{outputLab}
\alias{outputLab}
\title{Output labels.}
\usage{
outputLab(dataOut, blind, origP, maxRows, maxCols, newPack)
}
\arguments{
\item{dataOut}{Dataset to be formatted for packing list.}

\item{blind}{Indicator 0/1 select if a blinded (1) or unblinded(0) packing list is to be generated.}

\item{origP}{Indicator, 0/1, inclusion of the original packing location (1) or deletion of the packing location (0).}

\item{maxRows}{Maximum row for the output dataset.}

\item{maxCols}{Maximum column for the output dataset.}

\item{newPack}{0/1 indicator to generate new packing locations.}
}
\value{
A dataset to be used for packing lists.
}
\description{
Creates output labels for the randomized groups.
}
\examples{
blind <- outputLab(dataOut=serumRand,blind=1,origP=0,maxRows=9,maxCols=9,newPack=1)
unBlindSw <- outputLab(serumSwitchP,blind=0,origP=.,maxRows=.,maxCols=.,newPack=0)
}
